.H 1 "Memory Window"
This window allows memory to be examined and
edited as a sequence of 1-, 2-, 4-, or 8-byte cells.
With the line menus a cell's size and formatting options may be changed or
the cells near a displayed cell may be opened.
The keyboard language allows you to open a new cell at an arbitrary address,
assign the value of a C expression to a cell, or search through the cells for a specified value.
The Memory window is opened from the "views" menu in the Process window,
or the line menus in a Frame or Assembler window.
.P
While Frame windows are usually used to examine data,
the Memory window provides an alternative,
unstructured view of memory and is most useful when no symbol
table entries are available.
It is often easier to change the cell size and formatting options
from the Memory window than to perform a series of casts in a Frame window.
The Memory window also allows you to determine
how machine instructions or bit fields in structures are encoded.
.H 2 "Memory Layout"
The title bar identifies the window type and displays the
process id number or name of the core file.
All lines within a Memory window display the address and value of
a memory cell, and have the format:
.DS I N
address/size: value
.DE
.P
The formats of the address and value fields depend on the
formatting options that have been selected from the cell's line menu.
If multiple formatting options have been turned on the address and
value fields are displayed several times and the character `=' is used
as a separator.
The address field supports the same symbolic and numeric
formats used to display addresses in the Assembler window
(see "Assembler Layout").
The size is either 1, 2, 4, or 8 bytes.
.P
Lines that start with the special character sequence ">>>" are
spies, and will update their displayed values automatically.
On other lines, the displayed value is the value of the cell
when it was created in the window, or the last
time a formatting or size option was changed for the cell.
.P
The lines within the Memory window are sorted by address.
Creating a new cell with the same address as a previous entry in the window
overwrites the previous entry.
.H 2 "Memory Keyboard"
Syntax 
.DS I N
 . = expression
.DE
.P
The window's keyboard language accepts the address of a new memory cell.
When a line in this syntax is entered, the expression is evaluated
and the memory cell at the resulting address is displayed.
The format and size options for the new cell
are inherited from the last cell evaluated in the window.
.P
The expression may be constructed from global identifiers,
integer constants (C character, integer, and explicit long constants),
and the following C operators, listed in order of decreasing precedence:
.DS I N
Operator	Associativity
--------	-------------
() []		left to right
- &		right to left
* / %		left to right
+ -		left to right
.DE
.P
This restricted set of expressions is the same set accepted by the
Assembler window.
For example, to display the memory at the hexadecimal address 0x2020, type:
.DS I N
 .=0x2020
.DE
.P
while to see the encoding of the first instruction
mplementing the function main() type:
.DS I N
 .=&main
.DE
.H 2 "Memory Line Menus"
.VL 10 1
.LI "spy on"
Spy on the selected memory cell.
After selecting this entry, the characters ">>>" are inserted at the
beginning of the line to indicate the cell will
be reevaluated and displayed automatically, as described in "Spies".
This menu entry is not present when examining core dumps
or if the current expression is already a spy.
.LI "unspy"
Turn off spying for the selected memory cell.
This menu entry only appears if the cell is a spy.
.LI "size"
Change the size of the memory cell to the selected size,
and then reevaluate and display it.
The cell is reevaluated even if the new cell size is the same as the old,
providing a way to update the cell even though there is no explicit
evaluation entry in the menu.
When the window is first opened the default cell size is 1 byte.
.LI "format"
This sub-menu controls the format used to display
the address and value of the selected memory cell.
Choosing a formatting entry reevaluates the cell
and displays it with the newly selected format.
.LI "next"
Thhis sub-menu opens and displays from 1 to 100 of the memory
cells that follow the selected cell.
The format and size options for the new cells are inherited from
the selected cell.
.LI "prev"
Just like "next", except the memory cells before
the selected cell are displayed.
.LI "* thru ."
Treat the selected memory cell's value as an address,
and open the memory cell at that location.
This entry is useful for dereferencing cells that contain pointers.
The format and size options for the new cell are inherited from
the selected line.
This entry is not in the menu if the cell size is 8 bytes.
.LI "asmblr"
Open the Assembler window and disassemble the instruction
starting at the address of the memory cell.
If the cell's address is not on an instruction boundary,
the instruction printed in the Assembler window will be incorrect.
.LE
.P
The options in the "format" menu depends on the cell's size.
Some formatting options apply to both the address and value
fields of the cell, while others apply only to the value or only
to the address.
The formatting entries allow the current setting to be toggled:
.VL 18 1
.LI "unsd_dec on|off"
Display the address and value as unsigned decimal numbers.
.LI "sign_dec on|off"
Display the address and value as signed decimal numbers.
.LI "octal on|off"
Display the address and value as octal numbers.
.LI "hex on|off"
Display the address and value as hexadecimal numbers.
.LI "ascii on|off"
Display the value as a sequence of ASCII characters.
The number of characters displayed depends on the cell size.
.LI "symbolic on|off"
Display the address symbolically.
.LI "time on|off"
Treat the value as a Unix representation of time
(the number of seconds since the epoch 00:00:00 GMT, January 1, 1970),
and display it as an ASCII date and time.
This entry is only generated if the cell size is 4 bytes.
.LI "float on|off"
Display the value as a float using up to 6 decimal places.
This entry is only generated if the cell size is 4 bytes.
.LI "double on|off"
Display the value as a double using up to 15 decimal places.
This entry is only generated if the cell size is 8 bytes.
.LE
.H 2 "Memory Line Keyboard"
Syntax
.DS I N
 . = expression
 $ = expression
 <CR>
 /[string]
 ?string
.DE
.P
The keyboard language for a line allows you to enter the address of a new
memory cell, change the value of a memory cell, display the next cell,
or search forwards and backwards though cells for a string.
The format
.DS I N
 . = expression
.DE
.P
opens a new memory cell at the address given by the expression,
and behaves like the window's keyboard language.
The format
.DS I N
$ = expression
.DE
.P
evaluates the expression, assigns its value to the currently
selected memory cell, and then revaluates and displays the cell.
The C expression has the same restrictions as expressions used in
the window's keyboard language.
It may be constructed from global identifiers, integer constants,
and the C operators described in the "Memory Keyboard" section.
.P
Since the keyboard language's expression grammar
does not support floating point constants,
it is not possible to assign floating constants to 4-byte cells
or double constants to 8-byte cells.
Because C does not support 8 byte integer constants,
all assignments to 8-byte cells fail.
If you need to assign a value to a 8-byte cell,
break it into 2 4-byte cells and assign values to the two halves.
.P
A blank line, entered by typing just a carriage return,
displays the next cell and is equivalent t
selecting "next 1" in the cell's line menu.
.P
The last two keyboard formats:
.DS I N
/[string]
?string
.DE
.P
allow you to search forwards (backwards) through cells for the given string.
Starting at the first cell after (before) the selected cell,
pi evaluates the cell and formats the line into
an internal buffer, but does not display it in the window.
The cell size and formatting options are inherited from the selected cell.
A search is then made to see if the string is
embedded anywhere in the internal buffer.
The string must match exactly and is not a regular expression.
If a match is found, the search stops and the cell containing the
match is displayed and selected.
If no match is found, the search continues with the next
(previous) memory cell.
Once a search is started, it continues until either:
.AL 1
.LI
An exact match with the string is found.
.LI
An error occurs attempting to read a cell's memory.
This usually happens when the search reaches a segment boundary,
such as the end of the data segment.
.LI
10 seconds has elapsed and neither of the first two conditions is true.
.LE
.P
Because the string comparison is made with the formatted internal
buffer for each cell, and not directly with the cell's memory,
what a string matches will depend on the formatting options and
cell size of the selected line.
For example, if you have a big array of
floating point numbers and you know one has the value 3.14,
you can search for that value with the following sequence:
.AL 1
.LI
Open the memory cell for the first element of the array from the "mem .=$" menu
entry in a Frame window or using the ".=expression" keyboard syntax in
the Memory window.
.LI
Set the cell size to 4 bytes from the "size" menu.
.LI
Use the "format" menu to select "float on".
.LI
Enter "/3.14" from the keyboard.
.LE
.P
Similarly, you can search for numbers in octal, hex, signed
or unsigned decimal, or ASCII characters.
The internal buffer the comparison is made with contains an exact 
copy of what the window would display for that cell,
including the address field, so the string may match characters in the address.
For example, if the selected line displays:
.DS I N
0xEFFFC00/4: 0xEDF4157
.DE
.P
and you want to look at the entry that starts 0x20 bytes after this entry,
you may type:
.DS I N
/20/
.DE
.P
to search for it instead of typing in the whole address.
The closing `/' matches the `/' after the address field,
since that is the only `/' character that will appear in lines that
have the hexadecimal formatting option on.
.P
If the optional string is not present,
the string used in the last search is used again.
The string is required with `?' because if the
input line consists of the single character `?',
pi's help mechanism is invoked.
